<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Register Karyawan - Harris Absensi</title>

    <script src="https://cdn.tailwindcss.com"></script>

    <style>
        @import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&display=swap');

        * {
            font-family: 'Poppins', sans-serif;
        }

        html,
        body {
            height: 100%;
            overflow: hidden;
            position: fixed;
            width: 100%;
        }

        body {
            background: linear-gradient(135deg, #ffffff 0%, #fff5f0 100%);
        }

        .container-wrapper {
            height: 100vh;
            height: 100dvh;
            overflow: hidden;
        }

        .gradient-bg {
            background: linear-gradient(135deg, #FF6B35 0%, #FF8C42 100%);
        }

        .gradient-text {
            background: linear-gradient(135deg, #FF6B35 0%, #FF8C42 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }

        .input-field {
            transition: all 0.3s ease;
            border: 2px solid #f0f0f0;
        }

        .input-field:focus {
            border-color: #FF6B35;
            box-shadow: 0 0 0 4px rgba(255, 107, 53, 0.1);
        }

        .btn-primary {
            background: linear-gradient(135deg, #FF6B35 0%, #FF8C42 100%);
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(255, 107, 53, 0.3);
        }

        .btn-primary:active {
            transform: translateY(0);
        }

        .captcha-container {
            position: relative;
            overflow: hidden;
            border-radius: 12px;
            border: 2px solid #f0f0f0;
        }

        .captcha-image {
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .captcha-image:hover {
            opacity: 0.8;
        }

        .floating-shape {
            position: absolute;
            border-radius: 50%;
            opacity: 0.1;
            animation: float 20s infinite ease-in-out;
        }

        @keyframes float {

            0%,
            100% {
                transform: translate(0, 0) rotate(0deg);
            }

            33% {
                transform: translate(30px, -30px) rotate(120deg);
            }

            66% {
                transform: translate(-30px, 30px) rotate(240deg);
            }
        }

        .shape-1 {
            width: 300px;
            height: 300px;
            background: #FF6B35;
            top: -100px;
            right: -100px;
        }

        .shape-2 {
            width: 200px;
            height: 200px;
            background: #FF8C42;
            bottom: -50px;
            left: -50px;
            animation-delay: -5s;
        }

        .logo-text {
            font-weight: 800;
            font-size: 3rem;
            letter-spacing: -2px;
        }

        @media (max-width: 640px) {
            .logo-text {
                font-size: 2rem;
            }
        }

        .password-strength {
            height: 4px;
            border-radius: 2px;
            transition: all 0.3s ease;
        }
    </style>
</head>

<body class="overflow-hidden">
    <!-- Floating Shapes -->
    <div class="floating-shape shape-1"></div>
    <div class="floating-shape shape-2"></div>

    <div class="container-wrapper flex items-center justify-center p-2 sm:p-4 relative z-10">
        <div class="w-full max-w-6xl h-full flex items-center">
            <div class="grid lg:grid-cols-2 gap-4 lg:gap-8 items-center w-full max-h-full overflow-hidden">

                <!-- Left Side - Branding (Desktop Only) -->
                <div class="hidden lg:flex flex-col justify-center space-y-8 p-8">
                    <div class="space-y-4">
                        <div class="logo-container flex justify-center">
                            <img src="{{ asset('img/Logo.png') }}" alt="HARRIS Hotel Logo"
                                class="h-32 object-contain">
                        </div>
                    </div>

                    <div class="space-y-6">
                        <h2 class="text-4xl font-bold text-gray-800">
                            Bergabung Sebagai<br />
                            <span class="gradient-text">Karyawan</span>
                        </h2>
                        <p class="text-lg text-gray-600">
                            Daftarkan diri Anda untuk menggunakan sistem absensi digital
                        </p>
                    </div>
                </div>

                <!-- Right Side - Register Form -->
                <div class="w-full max-h-full overflow-y-auto overflow-x-hidden">
                    <div class="bg-white rounded-2xl lg:rounded-3xl shadow-2xl p-4 sm:p-8 lg:p-12">

                        <!-- Mobile Logo -->
                        <div class="lg:hidden text-center mb-4">
                    <div class="space-y-4">
                        <div class="logo-container flex justify-center">
                            <img src="{{ asset('img/Logo.png') }}" alt="HARRIS Hotel Logo"
                                class="h-24 object-contain">
                        </div>
                    </div>
                        </div>

                        <!-- Header -->
                        <div class="text-center mb-4 sm:mb-6">
                            <h2 class="text-2xl sm:text-1xl font-bold text-gray-800 mb-1 sm:mb-2">Daftar Karyawan</h2>
                            {{-- <p class="text-sm text-gray-600">Lengkapi data untuk membuat akun</p> --}}
                        </div>

                        <!-- Info Box -->
                        <div class="mb-4 bg-blue-50 border-l-4 border-blue-500 p-3 rounded-lg">
                            <div class="flex items-start">
                                <svg class="w-4 h-4 text-blue-500 mt-0.5 mr-2 flex-shrink-0" fill="currentColor"
                                    viewBox="0 0 20 20">
                                    <path fill-rule="evenodd"
                                        d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"
                                        clip-rule="evenodd"></path>
                                </svg>
                                <div class="flex-1">
                                    <p class="text-xs font-semibold text-blue-800 mb-1">Perhatian:</p>
                                    <p class="text-xs text-blue-700">Akun Anda akan aktif setelah disetujui oleh admin.
                                        Anda akan dihubungi melalui email.</p>
                                </div>
                            </div>
                        </div>

                        <!-- Error Messages -->
                        @if ($errors->any())
                            <div class="mb-4 bg-red-50 border-l-4 border-red-500 p-3 rounded-lg">
                                <div class="flex items-start">
                                    <svg class="w-4 h-4 text-red-500 mt-0.5 mr-2 flex-shrink-0" fill="currentColor"
                                        viewBox="0 0 20 20">
                                        <path fill-rule="evenodd"
                                            d="M10 18a8 8 0 100-16 8 8 0 000 16zM8.707 7.293a1 1 0 00-1.414 1.414L8.586 10l-1.293 1.293a1 1 0 101.414 1.414L10 11.414l1.293 1.293a1 1 0 001.414-1.414L11.414 10l1.293-1.293a1 1 0 00-1.414-1.414L10 8.586 8.707 7.293z"
                                            clip-rule="evenodd"></path>
                                    </svg>
                                    <div class="flex-1">
                                        <p class="text-xs font-semibold text-red-800 mb-1">Terjadi Kesalahan:</p>
                                        <ul class="text-xs text-red-700 space-y-1">
                                            @foreach ($errors->all() as $error)
                                                <li>{{ $error }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        @endif

                        <!-- Register Form -->
                        <form action="{{ route('register.post') }}" method="POST" id="registerForm">
                            @csrf

                            <!-- Nama Lengkap -->
                            <div class="mb-4">
                                <label for="nama" class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                                    Nama Lengkap <span class="text-red-500">*</span>
                                </label>
                                <div class="relative">
                                    <div
                                        class="absolute inset-y-0 left-0 pl-3 sm:pl-4 flex items-center pointer-events-none">
                                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-gray-400" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z">
                                            </path>
                                        </svg>
                                    </div>
                                    <input type="text" id="nama" name="nama" value="{{ old('nama') }}"
                                        required
                                        class="input-field w-full pl-10 sm:pl-12 pr-4 py-2.5 sm:py-3.5 rounded-xl outline-none text-gray-800 text-sm sm:text-base"
                                        placeholder="Nama lengkap Anda" autocomplete="name">
                                </div>
                            </div>

                            <!-- Email -->
                            <div class="mb-4">
                                <label for="email" class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                                    Email <span class="text-red-500">*</span>
                                </label>
                                <div class="relative">
                                    <div
                                        class="absolute inset-y-0 left-0 pl-3 sm:pl-4 flex items-center pointer-events-none">
                                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-gray-400" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M16 12a4 4 0 10-8 0 4 4 0 008 0zm0 0v1.5a2.5 2.5 0 005 0V12a9 9 0 10-9 9m4.5-1.206a8.959 8.959 0 01-4.5 1.207">
                                            </path>
                                        </svg>
                                    </div>
                                    <input type="email" id="email" name="email" value="{{ old('email') }}"
                                        required
                                        class="input-field w-full pl-10 sm:pl-12 pr-4 py-2.5 sm:py-3.5 rounded-xl outline-none text-gray-800 text-sm sm:text-base"
                                        placeholder="nama@email.com" autocomplete="email">
                                </div>
                                <p class="text-xs text-gray-500 mt-1">Gunakan email aktif untuk notifikasi</p>
                            </div>

                            <!-- Password -->
                            <div class="mb-4">
                                <label for="password"
                                    class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                                    Password <span class="text-red-500">*</span>
                                </label>
                                <div class="relative">
                                    <div
                                        class="absolute inset-y-0 left-0 pl-3 sm:pl-4 flex items-center pointer-events-none">
                                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-gray-400" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z">
                                            </path>
                                        </svg>
                                    </div>
                                    <input type="password" id="password" name="password" required minlength="6"
                                        class="input-field w-full pl-10 sm:pl-12 pr-10 sm:pr-12 py-2.5 sm:py-3.5 rounded-xl outline-none text-gray-800 text-sm sm:text-base"
                                        placeholder="Minimal 6 karakter" autocomplete="new-password"
                                        oninput="checkPasswordStrength()">
                                    <button type="button" onclick="togglePassword('password')"
                                        class="absolute inset-y-0 right-0 pr-3 sm:pr-4 flex items-center text-gray-400 hover:text-gray-600">
                                        <svg id="eye-icon-password" class="w-4 h-4 sm:w-5 sm:h-5" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                            </path>
                                        </svg>
                                    </button>
                                </div>
                                <!-- Password Strength Indicator -->
                                <div class="mt-2">
                                    <div id="password-strength-bar" class="password-strength bg-gray-200 w-0"></div>
                                    <p id="password-strength-text" class="text-xs text-gray-500 mt-1">Minimal 6
                                        karakter</p>
                                </div>
                            </div>

                            <!-- Konfirmasi Password -->
                            <div class="mb-4">
                                <label for="password_confirmation"
                                    class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                                    Konfirmasi Password <span class="text-red-500">*</span>
                                </label>
                                <div class="relative">
                                    <div
                                        class="absolute inset-y-0 left-0 pl-3 sm:pl-4 flex items-center pointer-events-none">
                                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-gray-400" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                        </svg>
                                    </div>
                                    <input type="password" id="password_confirmation" name="password_confirmation"
                                        required minlength="6"
                                        class="input-field w-full pl-10 sm:pl-12 pr-10 sm:pr-12 py-2.5 sm:py-3.5 rounded-xl outline-none text-gray-800 text-sm sm:text-base"
                                        placeholder="Ketik ulang password" autocomplete="new-password"
                                        oninput="checkPasswordMatch()">
                                    <button type="button" onclick="togglePassword('password_confirmation')"
                                        class="absolute inset-y-0 right-0 pr-3 sm:pr-4 flex items-center text-gray-400 hover:text-gray-600">
                                        <svg id="eye-icon-confirmation" class="w-4 h-4 sm:w-5 sm:h-5" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                            </path>
                                        </svg>
                                    </button>
                                </div>
                                <p id="password-match-message" class="text-xs mt-1 hidden"></p>
                            </div>

                            <!-- CAPTCHA -->
                            <div class="mb-6">
                                <label for="captcha"
                                    class="block text-xs sm:text-sm font-semibold text-gray-700 mb-2">
                                    Kode Keamanan <span class="text-red-500">*</span>
                                </label>

                                <div class="flex items-center gap-2 sm:gap-3 mb-2 sm:mb-3">
                                    <div class="captcha-container flex-shrink-0">
                                        <img src="{{ route('captcha') }}" alt="CAPTCHA" id="captcha-image"
                                            class="captcha-image h-12 sm:h-14 w-auto bg-gray-50"
                                            onclick="refreshCaptcha()" title="Klik untuk refresh">
                                    </div>
                                    <button type="button" onclick="refreshCaptcha()"
                                        class="p-2 sm:p-3 bg-gray-100 hover:bg-gray-200 rounded-xl transition"
                                        title="Refresh CAPTCHA">
                                        <svg class="w-4 h-4 sm:w-5 sm:h-5 text-gray-600" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15">
                                            </path>
                                        </svg>
                                    </button>
                                </div>

                                <input type="text" id="captcha" name="captcha" required maxlength="6"
                                    class="input-field w-full px-3 sm:px-4 py-2.5 sm:py-3.5 rounded-xl outline-none text-gray-800 text-sm sm:text-base"
                                    placeholder="Masukkan kode di atas" autocomplete="off">
                                <p class="text-xs text-gray-500 mt-1 flex items-start">
                                    <svg class="w-3 h-3 sm:w-4 sm:h-4 mr-1 mt-0.5 flex-shrink-0" fill="currentColor"
                                        viewBox="0 0 20 20">
                                        <path fill-rule="evenodd"
                                            d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z"
                                            clip-rule="evenodd"></path>
                                    </svg>
                                    <span class="text-xs">Ketik kode keamanan (tidak case-sensitive)</span>
                                </p>
                            </div>

                            <!-- Submit Button -->
                            <button type="submit" id="submit-btn"
                                class="btn-primary w-full text-white py-3 sm:py-4 rounded-xl font-semibold text-base sm:text-lg shadow-lg">
                                Daftar Sekarang
                            </button>
                        </form>

                        <!-- Login Link -->
                        <div class="mt-6 text-center">
                            <p class="text-sm text-gray-600">
                                Sudah punya akun?
                                <a href="{{ route('login') }}"
                                    class="text-orange-600 hover:text-orange-700 font-semibold">
                                    Login di sini
                                </a>
                            </p>
                        </div>

                        <!-- Footer -->
                        <div class="mt-6 text-center">
                            <p class="text-xs text-gray-500">
                                Dengan mendaftar, Anda menyetujui syarat dan ketentuan yang berlaku
                            </p>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <script>
        // Toggle password visibility
        function togglePassword(fieldId) {
            const field = document.getElementById(fieldId);
            const eyeIcon = document.getElementById('eye-icon-' + (fieldId === 'password' ? 'password' : 'confirmation'));

            if (field.type === 'password') {
                field.type = 'text';
                eyeIcon.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.88 9.88l-3.29-3.29m7.532 7.532l3.29 3.29M3 3l3.59 3.59m0 0A9.953 9.953 0 0112 5c4.478 0 8.268 2.943 9.543 7a10.025 10.025 0 01-4.132 5.411m0 0L21 21"></path>
                `;
            } else {
                field.type = 'password';
                eyeIcon.innerHTML = `
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                `;
            }
        }

        // Check password strength
        function checkPasswordStrength() {
            const password = document.getElementById('password').value;
            const strengthBar = document.getElementById('password-strength-bar');
            const strengthText = document.getElementById('password-strength-text');

            let strength = 0;
            let strengthLabel = '';
            let strengthColor = '';

            if (password.length >= 6) strength++;
            if (password.length >= 8) strength++;
            if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength++;
            if (/\d/.test(password)) strength++;
            if (/[^a-zA-Z\d]/.test(password)) strength++;

            switch (strength) {
                case 0:
                case 1:
                    strengthLabel = 'Lemah';
                    strengthColor = 'bg-red-500';
                    break;
                case 2:
                case 3:
                    strengthLabel = 'Sedang';
                    strengthColor = 'bg-yellow-500';
                    break;
                case 4:
                case 5:
                    strengthLabel = 'Kuat';
                    strengthColor = 'bg-green-500';
                    break;
            }

            strengthBar.className = `password-strength ${strengthColor}`;
            strengthBar.style.width = (strength * 20) + '%';
            strengthText.textContent = password ? `Kekuatan: ${strengthLabel}` : 'Minimal 6 karakter';
            strengthText.className =
                `text-xs mt-1 ${password ? (strength < 2 ? 'text-red-600' : strength < 4 ? 'text-yellow-600' : 'text-green-600') : 'text-gray-500'}`;
        }

        // Check password match
        function checkPasswordMatch() {
            const password = document.getElementById('password').value;
            const confirmation = document.getElementById('password_confirmation').value;
            const message = document.getElementById('password-match-message');

            if (confirmation.length === 0) {
                message.classList.add('hidden');
                return;
            }

            message.classList.remove('hidden');

            if (password === confirmation) {
                message.textContent = '✓ Password cocok';
                message.className = 'text-xs mt-1 text-green-600';
            } else {
                message.textContent = '✗ Password tidak cocok';
                message.className = 'text-xs mt-1 text-red-600';
            }
        }

        // Refresh CAPTCHA
        function refreshCaptcha() {
            const captchaImage = document.getElementById('captcha-image');
            const captchaInput = document.getElementById('captcha');

            captchaImage.src = '{{ route('captcha') }}?' + Date.now();
            captchaInput.value = '';
            captchaInput.focus();

            captchaImage.style.opacity = '0.5';
            setTimeout(() => {
                captchaImage.style.opacity = '1';
            }, 200);
        }

        // Form validation
        document.getElementById('registerForm').addEventListener('submit', function(e) {
            const password = document.getElementById('password').value;
            const confirmation = document.getElementById('password_confirmation').value;
            const captcha = document.getElementById('captcha').value;

            if (!captcha || captcha.length === 0) {
                e.preventDefault();
                alert('Kode CAPTCHA harus diisi!');
                document.getElementById('captcha').focus();
                return false;
            }

            if (password !== confirmation) {
                e.preventDefault();
                alert('Password dan konfirmasi password tidak cocok!');
                document.getElementById('password_confirmation').focus();
                return false;
            }

            if (password.length < 6) {
                e.preventDefault();
                alert('Password minimal 6 karakter!');
                document.getElementById('password').focus();
                return false;
            }
        });

        // Auto-focus on first error
        window.addEventListener('load', function() {
            @if ($errors->has('nama'))
                document.getElementById('nama').focus();
            @elseif ($errors->has('email'))
                document.getElementById('email').focus();
            @elseif ($errors->has('password'))
                document.getElementById('password').focus();
            @elseif ($errors->has('captcha'))
                document.getElementById('captcha').focus();
                refreshCaptcha();
            @endif
        });
    </script>
</body>

</html>
